<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Auth\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Auth\Services\MenuService;

class Menu extends BaseController {


	/**
	 * @title 权限节点列表
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, MenuService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 获取我的权限节点
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function my(Request $request, MenuService $service){
		try {
			$this->data['data'] = $service->getMyMenuList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加权限节点
	 *
	 * @param Request $request
	 * @param Department $service
	 * @return void
	 */
	public function add(Request $request, MenuService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 修改权限节点
	 *
	 * @param Request $request
	 * @param MenuService $service
	 * @return void
	 */
	public function edit(Request $request, MenuService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除权限节点
	 *
	 * @param Request $request
	 * @param MenuService $service
	 * @return void
	 */
	public function delete(Request $request, MenuService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
