<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Modules\System\Services\LogService;
use Illuminate\Support\Facades\Log;

class AuthCheckMiddleware {

	public function handle(Request $request, Closure $next, string $guard = 'admin'): Response {
		$response = $next($request);
		if (auth($guard)->check()) {
			if($guard == 'admin'){
				app(LogService::class)->createLog($request);
			}
			return $response;
		}else{
			return response()->json(['code' => 2000, 'message' => '未登录，请重新登录！']);
		}
	}
}
