<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Process;

class BaseController {

	protected $data = ['code' => 1, 'message' => 'success', 'data' => []];

	public function __construct(Request $request){
		if($request->filled('page')){
			$request->mergeIfMissing(['limit' => $request->input('limit', 30)]);
			$offset = intval($request->input('page', 1) - 1) * (int) $request->input('limit', 30);
			$request->mergeIfMissing(['offset' => $offset]);
		}

		$this->setCache();
	}

	public function setCache(){
		app(\Modules\System\Services\SettingService::class)->setCache();
		app(\Modules\Goods\Services\CategoryService::class)->setCategoryCache();
	}

	public function test(){
		try {
			$res = Process::run('php artisan config')->throw();
		} catch (\Throwable $th) {
			dd($th->getMessage());
		}

		dd($res->output());
		return $res->output();
	}
}
