### SentOS管理系统
SentOS管理系统是一个基于Laravel + Vue 开发的后台管理系统，主要功能包括：用户管理、角色管理、菜单管理、部门管理、日志管理、字典管理、参数管理、定时任务、在线文档、图片上传、富文本编辑器

### 运行环境

1. PHP >= 7.2.0
2. MySQL >= 5.7.0
3. Redis >= 4.0.0
4. Laravel >= 11.0.0
5. Vue >= 3.0.0
6. Node >= 16.0.0
7. Vite >= 4.0.0

### 服务器端安装
1. 运行composer install
2. 运行php artisan key:generate
3. 运行php artisan migrate
4. 运行php artisan db:seed --class=AdminSeeder
5. 运行php artisan db:seed --class=SystemSeeder
6. 运行php artisan serve

### 前端安装
1. cd resources/admin
2. npm install
3. npm run serve
4. 访问http://localhost:8080

### 功能
- [x] 用户管理 后台用户管理
- [x] 部门管理 配置公司的部门结构，支持树形结构
- [x] 菜单管理 配置系统菜单，按钮等等
- [x] 角色管理 配置用户担当的角色，分配权限
- [x] 配置管理 参数的管理
- [x] 字典管理 字典数据管理
- [x] 操作日志 后台用户操作记录

注意：
unlink public/storage      删除现有的链接 

php artisan storage:link   重新创建软链接访问图片

ln -s /www/wwwroot/jwhx.xicheda.cn/resources/attachs public/attachs 创建一个新的链接指向不同的目录

ls -l public/storage    检查是否存在链接

php artisan queue:work  命令启动一个队列工作进程（用于事件监听）

php artisan queue:work --daemon

清理和优化配置缓存
php artisan config:cache
清理和优化路由缓存
php artisan route:cache
清理和优化视图缓存
php artisan view:cache
清理日志文件
php artisan log:clear
注意：修改生成缓存文件权限



