import config from "@/config"
import http from "@/utils/request"

export default{
	lists: {
		list: {
			url: `${config.API_URL}store/index/index`,
			name: "获得店铺列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}store/index/add`,
			name: "添加店铺",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}store/index/edit`,
			name: "编辑店铺",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		audit: {
			url: `${config.API_URL}store/index/audit`,
			name: "审核店铺",
			post: async function(params){
				return await http.put(this.url, params);
			}
		}
	},
	category: {
		list: {
			url: `${config.API_URL}store/category/index`,
			name: "获得店铺分类列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}store/category/add`,
			name: "添加店铺分类",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}store/category/edit`,
			name: "编辑店铺分类",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}store/category/delete`,
			name: "删除店铺分类",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	goods: {
		delete: {
			url: `${config.API_URL}store/goods/delete`,
			name: "删除商品",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}store/goods/add`,
			name: "添加商品",
			post: async function(params){
				return await http.post(this.url, params);
			}
		}
	},
	merchant: {
		list: {
			url: `${config.API_URL}store/merchant/index`,
			name: "获得商家列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}store/merchant/add`,
			name: "添加商家",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}store/merchant/edit`,
			name: "编辑商家",
			post: async function(params){
				return await http.put(this.url, params);
			}
		}
	},
	payment: {
		list: {
			url: `${config.API_URL}store/payment/index`,
			name: "获得支付方式列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}store/payment/index`,
			name: "收款列表",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		qrcode: {
			url: `${config.API_URL}store/payment/qrcode`,
			name: "收款码",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		serviceqrcoed: {
			url: `${config.API_URL}store/payment/serviceqrcode`,
			name: "收款码",
			get: async function(params){
				return await http.get(this.url, params);
			}
		}
	}
}

