import config from "@/config"
import http from "@/utils/request"

export default{
	lists: {
		list: {
			url: `${config.API_URL}member/index/index`,
			name: "获得会员列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}member/index/add`,
			name: "添加会员",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}member/index/edit`,
			name: "编辑会员",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}member/index/delete`,
			name: "删除会员",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	level: {
		list: {
			url: `${config.API_URL}member/level/index`,
			name: "获得会员等级列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}member/level/add`,
			name: "添加会员等级",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}member/level/edit`,
			name: "编辑会员等级",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}member/level/delete`,
			name: "删除会员等级",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	score: {
		list: {
			url: `${config.API_URL}member/score/index`,
			name: "获得积分列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}member/score/add`,
			name: "添加积分",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}member/score/edit`,
			name: "编辑积分",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}member/score/delete`,
			name: "删除积分",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	account: {
		list: {
			url: `${config.API_URL}member/account/index`,
			name: "获得会员账户列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}member/account/add`,
			name: "添加会员账户",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}member/account/edit`,
			name: "编辑会员账户",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}member/account/delete`,
			name: "删除会员账户",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		withdraw:{
			url: `${config.API_URL}member/account/withdraw`,
			name: "通过提现",
			post: async function(params){
				return await http.post(this.url, params);
			}
		}
	},
	promoter: {
		list: {
			url: `${config.API_URL}member/promoter/index`,
			name: "获得推广员列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		audit: {
			url: `${config.API_URL}member/promoter/audit`,
			name: "审核推广员",
			post: async function(params){
				return await http.put(this.url, params);
			}
		}
	}
}
