import config from "@/config"
import http from "@/utils/request"

export default {
	category: {
		list: {
			url: `${config.API_URL}cms/category/index`,
			name: "获取栏目列表",
			get: async function(params){
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}cms/category/add`,
			name: "添加栏目",
			post: async function(params){
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}cms/category/edit`,
			name: "编辑栏目",
			post: async function(params){
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}cms/category/delete`,
			name: "删除栏目",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	model: {
		list: {
			url: `${config.API_URL}cms/model/index`,
			name: "模型列表",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}cms/model/add`,
			name: "模型添加",
			post: async function(params) {
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}cms/model/edit`,
			name: "模型修改",
			post: async function(params) {
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}cms/model/delete`,
			name: "删除模型",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	field: {
		list: {
			url: `${config.API_URL}cms/field/index`,
			name: "字段列表",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}cms/field/add`,
			name: "字段添加",
			post: async function(params) {
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}cms/field/edit`,
			name: "字段修改",
			post: async function(params) {
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}cms/field/delete`,
			name: "删除字段",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		},
		field: {
			url: `${config.API_URL}cms/field/fields`,
			name: "数据库内字段列表",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		},
		setting: {
			url: `${config.API_URL}cms/field/setting`,
			name: "字段设置",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		}
	},
	content: {
		list: {
			url: `${config.API_URL}cms/content/index`,
			name: "内容列表",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}cms/content/add`,
			name: "内容添加",
			post: async function(params) {
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}cms/content/edit`,
			name: "内容修改",
			post: async function(params) {
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}cms/content/delete`,
			name: "删除内容",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	},
	simple: {
		list: {
			url: `${config.API_URL}cms/simple/index`,
			name: "简单内容列表",
			get: async function(params) {
				return await http.get(this.url, params);
			}
		},
		add: {
			url: `${config.API_URL}cms/simple/add`,
			name: "简单内容添加",
			post: async function(params) {
				return await http.post(this.url, params);
			}
		},
		edit: {
			url: `${config.API_URL}cms/simple/edit`,
			name: "简单内容修改",
			post: async function(params) {
				return await http.put(this.url, params);
			}
		},
		delete: {
			url: `${config.API_URL}cms/simple/delete`,
			name: "删除简单内容",
			post: async function(params){
				return await http.delete(this.url, params);
			}
		}
	}
}
