<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;

class Index extends BaseController {

	/**
	 * @title 系统信息
	 *
	 * @return void
	 */
	public function version(Request $request){
		$system_info_mysql = \Illuminate\Support\Facades\DB::select("select version() as v;");

		$this->data['data'] = [
			['label' => '系统核心版本', 'values' => env('version', '0.0.1')],
			['label' => '服务器操作系统', 'values' => PHP_OS],
			['label' => '运行环境', 'values' => $_SERVER['SERVER_SOFTWARE']],
			['label' => 'MYSQL版本', 'values' => $system_info_mysql[0]->v],
			['label' => '上传限制', 'values' => '10']
		];
		return response()->json($this->data);
	}

	/**
	 * @title 系统信息
	 *
	 * @return void
	 */
	public function info(Request $request){
		$this->data['data'] = [
			['label' => '系统名称', 'values' => 'SentCMS'],
			['label' => '后端框架', 'values' => 'PHP8 + Laravel 11.*'],
			['label' => '前端框架', 'values' => 'VITE + VUE3 + element-plus'],
			['label' => '系统后台UI', 'values' => 'SCUI 1.6.9'],
			['label' => 'Development', 'values' => 'molong']
		];
		return response()->json($this->data);
	}

	/**
	 * @title 清理缓存
	 *
	 * @return void
	 */
	public function clearcache(Request $request){
		$this->data['data'] = cache()->flush();
		return response()->json($this->data);
	}
}
