<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\System\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\System\Services\AreaService;

class Area extends BaseController {

	/**
	 * @title 地区列表
	 *
	 * @param Request $request
	 * @param AreaService $service
	 * @return void
	 */
	public function index(Request $request, AreaService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}

	/**
	 * @title 添加地区
	 *
	 * @param Request $request
	 * @param AreaService $service
	 * @return void
	 */
	public function add(Request $request, AreaService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}

	/**
	 * @title 编辑地区
	 *
	 * @param Request $request
	 * @param AreaService $service
	 * @return void
	 */
	public function edit(Request $request, AreaService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}
		return response()->json($this->data);
	}
}
