<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

Route::name('store.')->prefix('store')->middleware(['auth.check:admin'])->group(function () {
	Route::controller(Modules\Store\Controllers\Admin\Index::class)->prefix('index')->name('index.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::put('/audit', 'audit')->name('audit');
		Route::put('/copy', 'copy')->name('copy');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Store\Controllers\Admin\Category::class)->prefix('category')->name('category.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Store\Controllers\Admin\Goods::class)->prefix('goods')->name('goods.')->group(function () {
		Route::post('/add', 'add')->name('add');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Store\Controllers\Admin\Merchant::class)->prefix('merchant')->name('merchant.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});

	Route::controller(Modules\Store\Controllers\Admin\Payment::class)->prefix('payment')->name('payment.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
		Route::get('/qrcode', 'qrcode')->name('qrcode');
		Route::get('/serviceqrcode', 'serviceqrcode')->name('serviceqrcode');
	});
});
