<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\OrderService;

class Order extends BaseController {

	/**
	 * @title 订单列表
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function index(Request $request, OrderService $service){
		try {
			$request->mergeIfMissing([
				'is_user' => 1
			]);
			$this->data['data'] = $service->getDataList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单商品列表
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function lists(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->getList($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 添加订单
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function add(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->create($request);
			$this->data['message'] = '下单成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 立即下单
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function simple(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->simpleCreate($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 更新订单
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function edit(Request $request, OrderService $service){
		try {
			$service->update($request);
			$this->data['message'] = '更新成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 删除订单
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function delete(Request $request, OrderService $service){
		try {
			$service->delete($request);
			$this->data['message'] = '删除成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 取消订单
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function cancel(Request $request, OrderService $service){
		try {
			$service->cancel($request);
			$this->data['message'] = '取消成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单详情
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function detail(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->getData($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 产品数量修改
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function number(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->setNumber($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 确认收货
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function take(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->orderTake($request);
			$this->data['message'] = '已确认收货';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 发货
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function send(Request $request, OrderService $service){
		try {
			$service->orderSend($request);
			$this->data['message'] = '发货成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单扫描核销
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function scan(Request $request, OrderService $service){
		try {
			$service->orderScan($request);
			$this->data['message'] = '核销成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单退款
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function refund(Request $request, OrderService $service){
		try {
			$this->data['data'] = $service->orderRefund($request);
			$this->data['message'] = '退款审核操作成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 订单支付检测
	 *
	 * @param Request $request
	 * @param OrderService $service
	 * @return void
	 */
	public function paycheck(Request $request, OrderService $service){
		try {
			$service->paySuccess($request->input('order_no'));
			$this->data['message'] = '支付成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}

	public function addaddress(Request $request, OrderService $service){
		try {
			$service->addAddress($request);
			$this->data['message'] = '添加成功';
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return response()->json($this->data);
	}
}
