<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Order\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Order\Services\OrderService;
use Modules\Order\Services\RefundService;

class Refund extends BaseController {

	/**
	 * @title 退款列表
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function index(Request $request, RefundService $service){
		try {
			$this->data['data'] = $service->getDataList($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}

	/**
	 * @title 退款审核
	 *
	 * @return \Illuminate\Http\JsonResponse
	 */
	public function audit(Request $request, RefundService $service){
		try {
			$this->data['data'] = $service->audit($request);
		} catch (\Exception $e) {
			$this->data['code'] = 0;
			$this->data['message'] = $e->getMessage();
		}

		return response()->json($this->data);
	}
}
