<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace Modules\Member\Controllers\Api;

use Illuminate\Http\Request;
use App\Http\Controllers\BaseController;
use Modules\Member\Services\BankService;

class Bank extends BaseController {

	/**
	 * @title 银行卡列表
	 *
	 * @param [type] $request
	 * @param BankService $service
	 * @return void
	 */
	public function index(Request $request, BankService $service){
		$request->mergeIfMissing(
			['is_user' => 1]
		);

		$this->data['data'] = $service->getDataList($request);
		return $this->data;
	}

	/**
	 * @title 添加银行卡
	 *
	 * @param Request $request
	 * @param BankService $service
	 * @return void
	 */
	public function add(Request $request, BankService $service){
		try {
			$this->data['data'] = $service->create($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}

	/**
	 * @title 编辑银行卡
	 *
	 * @param Request $request
	 * @param BankService $service
	 * @return void
	 */
	public function edit(Request $request, BankService $service){
		try {
			$this->data['data'] = $service->update($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}

	/**
	 * @title 删除银行卡
	 *
	 * @param Request $request
	 * @param BankService $service
	 * @return void
	 */
	public function delete(Request $request, BankService $service){
		try {
			$this->data['data'] = $service->delete($request);
		} catch (\Throwable $th) {
			$this->data['code'] = 0;
			$this->data['message'] = $th->getMessage();
		}

		return $this->data;
	}
}