<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
		Schema::create('goods', function (Blueprint $table) {
			$table->id()->unique()->comment('商品ID');
			$table->unsignedBigInteger('store_id')->default(0)->comment('店铺ID');
			$table->unsignedBigInteger('brand_id')->nullable()->comment('品牌ID');
			$table->unsignedBigInteger('user_id')->comment('发布人UID');
			$table->string('title', 255)->comment('商品名称');
			$table->string('description', 255)->nullable()->comment('商品描述');
			$table->text('tags')->nullable()->comment('商品标签');
			$table->string('cover', 255)->nullable()->comment('商品封面');
			$table->text('images')->nullable()->comment('商品图片');
			$table->decimal('price', total: 10, places: 2)->default(0)->comment('商品价格');
			$table->decimal('original_price', total: 10, places: 2)->default(0)->comment('商品原价');
			$table->unsignedInteger('integral')->default(0)->comment('积分');
			$table->string('unit', 50)->nullable()->comment('商品单位');
			$table->tinyInteger('goods_type')->default(0)->comment('商品类型');
			$table->string('operate', 200)->nullable()->comment('参与的活动');
			$table->text('content')->nullable()->comment('商品详情');
			$table->unsignedTinyInteger('sort')->default(0)->comment('排序');
			$table->unsignedInteger('sales')->default(0)->comment('销售量');
			$table->unsignedInteger('score')->default(0)->comment('可兑换积分');
			$table->tinyInteger('spec')->default(0)->comment('规格，0单规格 1多规格');
			$table->text('spec_list')->nullable()->comment('商品规格数据');
			$table->decimal('postage', total: 10, places: 2)->default(0)->comment('邮费');
			$table->tinyInteger('is_recom')->default(0)->comment('是否推荐');
			$table->tinyInteger('is_hot')->default(0)->comment('是否热门');
			$table->tinyInteger('is_new')->default(0)->comment('是否新品');
			$table->unsignedInteger('views')->default(0)->comment('浏览量');
			$table->unsignedInteger('stock')->default(0)->comment('库存');
			$table->tinyInteger('is_repeat_buy')->default(1)->comment('是否可复购');
			$table->tinyInteger('level_id')->default(1)->comment('兑换等级ID');
			$table->unsignedInteger('comments')->default(0)->comment('评论数');
			$table->unsignedInteger('collects')->default(0)->comment('收藏数');
			$table->tinyInteger('status')->default(1)->comment('状态 1上架 0下架');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');
			$table->string('goods_sn')->nullable()->comment('商品编号');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品表');
		});
		Schema::create('goods_brand', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('品牌名称');
			$table->string('logo')->nullable()->comment('品牌logo');
			$table->string('description')->nullable()->comment('品牌描述');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品品牌表');
		});
		Schema::create('goods_category', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('parent_id')->default(0)->comment('父级分类ID');
			$table->string('icon')->nullable()->comment('分类图标');
			$table->string('title')->comment('分类标题');
			$table->string('keywords')->nullable()->comment('分类关键字');
			$table->string('description')->nullable()->comment('分类描述');
			$table->string('cover')->nullable()->comment('分类封面');
			$table->string('ads_place')->nullable()->comment('滚动图标识');
			$table->tinyInteger('is_recom')->default(0)->comment('是否推荐');
			$table->string('sort')->default(0)->comment('排序');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品分类表');
		});
		Schema::create('goods_has_category', function (Blueprint $table) {
			$table->unsignedBigInteger('category_id')->comment('分类ID');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->primary(['category_id', 'goods_id']);

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品分类关联表');
		});
		Schema::create('goods_comment', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('goods_id')->comment('商品ID');
			$table->unsignedBigInteger('member_id')->comment('用户ID');
			$table->string('content')->comment('评论内容');
			$table->tinyInteger('status')->default(1)->comment('状态 1正常 2禁用');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品评论表');
		});
		Schema::create('goods_spec', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->string('title')->comment('规格名称');
			$table->string('value')->comment('规格值');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品规格表');
		});
		Schema::create('goods_sku', function (Blueprint $table) {
			$table->id()->uniqid()->comment('主键id');
			$table->unsignedBigInteger('goods_id')->default(0)->comment('商品ID');
			$table->string('sku')->uniqid()->comment('sku');
			$table->text('sku_value')->nullable()->comment('sku值');
			$table->unsignedInteger('stock')->default(0)->comment('库存');
			$table->unsignedInteger('sales')->default(0)->comment('销售量');
			$table->decimal('price', total: 10, places: 2)->default(0)->comment('价格');
			$table->decimal('original_price', total: 10, places: 2)->default(0)->comment('原价');
			$table->unsignedInteger('integral')->default(0)->comment('积分');
			$table->string('cover', 255)->nullable()->comment('商品封面');
			$table->timestamp('created_at')->nullable()->comment('创建时间');
			$table->timestamp('updated_at')->nullable()->comment('更新时间');

			$table->engine = 'InnoDB';
			$table->charset = 'utf8mb4';
			$table->collation = 'utf8mb4_unicode_ci';
			$table->comment('商品规格值表');
		});
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
		Schema::dropIfExists('goods');
		Schema::dropIfExists('goods_brand');
		Schema::dropIfExists('goods_category');
		Schema::dropIfExists('goods_has_category');
		Schema::dropIfExists('goods_comment');
		Schema::dropIfExists('goods_spec');
		Schema::dropIfExists('goods_sku');
    }
};
