<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
use Illuminate\Support\Facades\Route;

// 权限路由
Route::post('/auth/login', [Modules\Auth\Controllers\Admin\Index::class, 'login'])->name('auth.login');
Route::name('auth.')->prefix('auth')->middleware(['auth.check:admin'])->group(function () {
	Route::get('/user', [Modules\Auth\Controllers\Admin\Index::class, 'user'])->name('user');
	Route::post('/logout', [Modules\Auth\Controllers\Admin\Index::class, 'logout'])->name('logout');
	Route::post('/refresh', [Modules\Auth\Controllers\Admin\Index::class, 'refresh'])->name('refresh');

	Route::controller(Modules\Auth\Controllers\Admin\Users::class)->prefix('users')->name('users.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::put('/uprole', 'uprole')->name('uprole');
		Route::put('/passwd', 'passwd')->name('passwd');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Auth\Controllers\Admin\Menu::class)->prefix('menu')->name('menu.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::get('/my', 'my')->name('my');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Auth\Controllers\Admin\Role::class)->prefix('role')->name('role.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::put('/auth', 'auth')->name('auth');
		Route::delete('/delete', 'delete')->name('delete');
	});
	Route::controller(Modules\Auth\Controllers\Admin\Department::class)->prefix('department')->name('department.')->group(function () {
		Route::get('/index', 'index')->name('index');
		Route::post('/add', 'add')->name('add');
		Route::put('/edit', 'edit')->name('edit');
		Route::delete('/delete', 'delete')->name('delete');
	});
});
