<?php
// +----------------------------------------------------------------------
// | SentCMS [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2024 http://www.tensent.cn All rights reserved.
// +----------------------------------------------------------------------
// | Author: molong <molong@tensent.cn> <http://www.tensent.cn>
// +----------------------------------------------------------------------
namespace App\Console\Commands;

use Illuminate\Console\Command;
use GatewayWorker\BusinessWorker;
use GatewayWorker\Gateway;
use GatewayWorker\Register;
use Workerman\Worker;
use App\Events\WorkermanEvent;

class WorkermanWin extends Command {

	// 兼容windows
	protected $signature = 'wk {action : action} {--start=all : start} {--d : daemon mode}';

	protected $description = 'Start a Workerman server.';

	public function handle() {
		global $argv;
		$action = $this->argument('action');


        //针对 Windows 一次执行，无法注册多个协议的特殊处理
        if ($action === 'single') {
            $start = $this->option('start');
            if ($start === 'register') {
                $this->startRegister();
            } elseif ($start === 'gateway') {
                $this->startGateWay();
            } elseif ($start === 'worker') {
                $this->startBusinessWorker();
            }
            Worker::runAll();

            return;
        }

        $argv[1] = $action;
        $argv[2] = $this->option('d') ? '-d' : '';

        $this->start();
	}

	public function start() {
		$this->startGateWay();
		$this->startBusinessWorker();
		$this->startRegister();
		Worker::runAll();
	}

	public function startGateWay() {
		$gateway = new Gateway("websocket://0.0.0.0:2346");
		$gateway->name = 'Gateway';
		$gateway->count = 4;
		$gateway->lanIp = '127.0.0.1';
		$gateway->startPort = 2900;
		$gateway->pingInterval = 10;
		$gateway->pingNotResponseLimit = 1;
		$gateway->pingData = '{"type":"pong"}';
		$gateway->registerAddress = '127.0.0.1:1236';
	}

	public function startBusinessWorker() {
        $worker = new BusinessWorker();
        $worker->name = 'BusinessWorker';
        $worker->count = 3;
        $worker->registerAddress = '127.0.0.1:1236';
        $worker->eventHandler = WorkermanEvent::class;
	}

	public function startRegister() {
		$register = new Register('text://0.0.0.0:1236');
	}
}
